/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.traceroute;

import ibm.nways.jdm.common.Gauge;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.traceroute.NetInterface;
import ibm.nways.jdm.traceroute.Node;
import ibm.nways.jdm.traceroute.RemotePingException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;

public class Connection
implements Serializable {
    public static final int NO_TIME = -1;
    private boolean responseTimeChecked;
    private boolean rPingNodeSearched;
    private int responseTime;
    public static final String PROP_CHANGE_RESPONSE_TIME = "responseTime";
    protected Node rPingNode;
    protected NetInterface netInterface;
    protected Node node1;
    protected Node node2;
    protected boolean netIfNeedsLookup;
    protected Vector connections;
    protected Vector listeners;
    private static ResourceBundle strings = ResourceBundle.getBundle((class$ibm$nways$jdm$traceroute$TraceRouteResources != null ? class$ibm$nways$jdm$traceroute$TraceRouteResources : (class$ibm$nways$jdm$traceroute$TraceRouteResources = Connection.class$("ibm.nways.jdm.traceroute.TraceRouteResources"))).getName());
    private static final boolean debug = false;
    static /* synthetic */ Class class$ibm$nways$jdm$traceroute$TraceRouteResources;

    public Connection(Node node, Node node2, NetInterface netInterface) {
        this.node1 = node;
        this.node2 = node2;
        this.netInterface = netInterface;
        this.netIfNeedsLookup = false;
        this.responseTime = -1;
        this.responseTimeChecked = false;
    }

    public Connection(Node node, Node node2, int n) {
        this.node1 = node;
        this.node2 = node2;
        this.netInterface = null;
        this.netIfNeedsLookup = true;
        this.responseTime = n;
        this.responseTimeChecked = true;
    }

    public Node getNode() {
        return this.node1;
    }

    public Node getOtherNode(Node node) {
        if (this.node1.equals(node)) {
            return this.node2;
        }
        if (this.node2.equals(node)) {
            return this.node1;
        }
        return null;
    }

    public boolean equals(Connection connection) {
        if (this.node1.equals(connection.node1) && this.node2.equals(connection.node2)) {
            return true;
        }
        return this.node1.equals(connection.node2) && this.node2.equals(connection.node1);
    }

    public boolean equals(Object object) {
        if (object instanceof Connection) {
            return this.equals((Connection)object);
        }
        return false;
    }

    public boolean isNeighbor(Connection connection) {
        return this.getCommonNode(connection) != null;
    }

    public Node getCommonNode(Connection connection) {
        if (this.equals(connection)) {
            return null;
        }
        if (this.node1.equals(connection.node1)) {
            return this.node1;
        }
        if (this.node1.equals(connection.node2)) {
            return this.node1;
        }
        if (this.node2.equals(connection.node1)) {
            return this.node2;
        }
        if (this.node2.equals(connection.node2)) {
            return this.node2;
        }
        return null;
    }

    private synchronized void lookupNetInterface() {
        Object[] objectArray;
        if (!this.netIfNeedsLookup) {
            return;
        }
        try {
            objectArray = this.node1.getInterfaceAndNextHop(this.node2);
            this.netInterface = (NetInterface)objectArray[0];
        }
        catch (Exception exception) {}
        if (this.netInterface == null) {
            try {
                objectArray = this.node2.getInterfaceAndNextHop(this.node1);
                this.netInterface = (NetInterface)objectArray[0];
            }
            catch (Exception exception) {}
        }
        this.netIfNeedsLookup = false;
    }

    public Node getRpingNode() {
        this.findRpingNode();
        return this.rPingNode;
    }

    protected Node grabRpingNode() {
        if (this.node1 != null && this.node1.supportsRemotePing()) {
            return this.node1;
        }
        if (this.node2 != null && this.node2.supportsRemotePing()) {
            return this.node2;
        }
        return null;
    }

    protected synchronized void calcResponseTime() {
        if (this.responseTimeChecked) {
            return;
        }
        this.responseTimeChecked = true;
        this.findRpingNode();
        if (this.rPingNode == null) {
            return;
        }
        try {
            int n = this.responseTime;
            if (this.rPingNode == this.node1 || this.rPingNode == this.node2) {
                Node node = this.getOtherNode(this.rPingNode);
                this.responseTime = this.rPingNode.remotePing(node.getIPAddress());
            } else {
                int n2 = this.rPingNode.remotePing(this.node1.getIPAddress());
                int n3 = this.rPingNode.remotePing(this.node2.getIPAddress());
                this.responseTime = Math.abs(n2 - n3);
            }
            if (n != this.responseTime) {
                this.notifyPropertyChangeListeners(PROP_CHANGE_RESPONSE_TIME, n, this.responseTime);
                return;
            }
        }
        catch (RemotePingException remotePingException) {}
    }

    private synchronized void findRpingNode() {
        if (this.rPingNodeSearched) {
            return;
        }
        this.findRpingNodeImpl(-2, -2);
    }

    private synchronized void findRpingNodeImpl(int n, int n2) {
        Node node;
        Node node2;
        if (n == -2 && n2 == -2) {
            this.rPingNode = this.grabRpingNode();
            if (this.rPingNode == null && this.connections != null) {
                int n3 = this.connections.indexOf(this);
                if (n3 == -1) {
                    return;
                }
                this.findRpingNodeImpl(n3 - 1, n3 + 1);
            }
            return;
        }
        if (n < 0 && n2 >= this.connections.size()) {
            return;
        }
        if (n >= 0 && (node2 = ((Connection)this.connections.elementAt(n)).grabRpingNode()) != null) {
            this.rPingNode = node2;
            return;
        }
        if (n2 < this.connections.size() && (node = ((Connection)this.connections.elementAt(n2)).grabRpingNode()) != null) {
            this.rPingNode = node;
            return;
        }
        this.findRpingNodeImpl(n - 1, n2 + 1);
    }

    public synchronized void clearResponseTime() {
        this.responseTimeChecked = false;
    }

    public int getResponseTime() {
        this.calcResponseTime();
        return this.responseTime;
    }

    public synchronized String getResponseTimeString() {
        this.calcResponseTime();
        if (this.responseTime == -1) {
            return strings.getString("TimeUnknown");
        }
        return String.valueOf(this.responseTime) + strings.getString("Milliseconds");
    }

    public void setConnections(Vector vector) {
        this.connections = vector;
    }

    public NetInterface getNetInterface() {
        return this.netInterface;
    }

    public Integer getLinkType() {
        if (this.netIfNeedsLookup) {
            this.lookupNetInterface();
        }
        if (this.netInterface == null) {
            return null;
        }
        return this.netInterface.getIfType();
    }

    public String getLinkTypeString() {
        if (this.netIfNeedsLookup) {
            this.lookupNetInterface();
        }
        if (this.netInterface == null) {
            return NetInterface.UNAVAILABLE;
        }
        return this.netInterface.getIfTypeString();
    }

    public OctetString getLinkDescr() {
        if (this.netIfNeedsLookup) {
            this.lookupNetInterface();
        }
        if (this.netInterface == null) {
            return null;
        }
        return this.netInterface.getIfDescr();
    }

    public String getLinkDescrString() {
        if (this.netIfNeedsLookup) {
            this.lookupNetInterface();
        }
        if (this.netInterface == null) {
            return NetInterface.UNAVAILABLE;
        }
        return this.netInterface.getIfDescrString();
    }

    public Gauge getLinkSpeed() {
        if (this.netIfNeedsLookup) {
            this.lookupNetInterface();
        }
        if (this.netInterface == null) {
            return null;
        }
        return this.netInterface.getIfSpeed();
    }

    public String getLinkSpeedString() {
        if (this.netIfNeedsLookup) {
            this.lookupNetInterface();
        }
        if (this.netInterface == null) {
            return NetInterface.UNAVAILABLE;
        }
        return this.netInterface.getIfSpeedString();
    }

    public Integer getLinkStatus() {
        if (this.netIfNeedsLookup) {
            this.lookupNetInterface();
        }
        if (this.netInterface == null) {
            return null;
        }
        return this.netInterface.getIfOperStatus();
    }

    public String getLinkStatusString() {
        if (this.netIfNeedsLookup) {
            this.lookupNetInterface();
        }
        if (this.netInterface == null) {
            return NetInterface.UNAVAILABLE;
        }
        if (this.netInterface.isLanAdapter() == null || this.netInterface.isLanAdapter().booleanValue()) {
            return this.netInterface.getIfOperStatusString();
        }
        return this.netInterface.getUtilization(true);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners != null) {
            this.listeners.removeElement(propertyChangeListener);
        }
    }

    protected void notifyPropertyChangeListeners(String string, int n, int n2) {
        if (this.listeners == null) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, new Integer(n), new Integer(n2));
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((PropertyChangeListener)enumeration.nextElement()).propertyChange(propertyChangeEvent);
        }
    }

    public String toString() {
        return String.valueOf(this.node1) + " -- " + this.responseTime + " -- " + this.node2 + " via IF " + this.netInterface;
    }

    public void debugDump() {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            System.out.println("CONNECTION");
            System.out.println("    Node1: " + this.node1.getIPAddress());
            System.out.println("    Node2: " + this.node2.getIPAddress());
            System.out.println("Interface: " + this.netInterface);
            System.out.println("  TimeChk: " + this.responseTimeChecked);
            System.out.println("     Time: " + this.responseTime);
            System.out.println("  PingChk: " + this.rPingNodeSearched);
            if (this.rPingNode == null) {
                System.out.println(" PingNode: null");
            } else {
                System.out.println(" PingNode: " + this.rPingNode.getIPAddress());
            }
            System.out.println("   Others: " + this.connections);
            if (this.netInterface == null) {
                System.out.println("Interface Details: interface is null");
            } else {
                System.out.println("Interface Details:");
                this.netInterface.debugDump();
            }
            return;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

